<?php

namespace App\Controllers;

use App\Models\OrganizationModel;

class OrganizationsController extends BaseController
{
    protected $organizationModel;

    public function __construct()
    {
        $this->organizationModel = new OrganizationModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'tahun_mulai' => $this->request->getGet('tahun_mulai') ?? '',
            'tahun_selesai' => $this->request->getGet('tahun_selesai') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'urutan';
        $order = $this->request->getGet('order') ?? 'ASC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->organizationModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $perPage = 10;
        $organizations = $builder->get($perPage, ($page - 1) * $perPage)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('organizations', $page, $perPage, $total);
        
        // Calculate last page manually to ensure it works
        $lastPage = (int) ceil($total / $perPage);

        $data = [
            'title' => 'Organisasi - Portfolio',
            'organizations' => $organizations,
            'pager' => $pager,
            'lastPage' => $lastPage,
            'currentPage' => $page,
            'total' => $total,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('organizations/index', $data);
    }
}

